/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.usage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.LongMath;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.report.usage.LpseEstimator;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldLpseEstimator
implements LpseEstimator {
    private static final Logger log = LoggerFactory.getLogger(OldLpseEstimator.class);
    private final Superplan superplan;
    private final Map<GeneralizedActionRequest, Lpse> garLpses;
    private final Map<GeneralizedOrderRequest, Lpse> gorLpses;
    private final Map<GeneralizedOrderRequest, Long> predGorLpes;
    private final SuccGorFinder succGors;
    private final LpsComputer lpsComputer;
    private boolean estimated = false;

    public OldLpseEstimator(@Nonnull Superplan superplan) {
        this(superplan, GorSuccesorsFrom.FEEDS_PROPERTY, LpsEstimatesFrom.NON_STOP_ONLINE);
    }

    public OldLpseEstimator(@Nonnull Superplan superplan, GorSuccesorsFrom gsf, LpsEstimatesFrom lps) {
        this.superplan = Preconditions.checkNotNull(superplan, "superplan");
        this.garLpses = Maps.newIdentityHashMap();
        this.gorLpses = Maps.newIdentityHashMap();
        this.predGorLpes = Maps.newIdentityHashMap();
        this.succGors = gsf.getSuccGorFinder(superplan);
        this.lpsComputer = lps.getLpsComputer(superplan);
        this.estimate();
    }

    public Superplan getSuperplan() {
        return this.superplan;
    }

    public void estimate() {
        if (this.estimated) {
            return;
        }
        ArrayList<GeneralizedOrderRequest> visitedStack = Lists.newArrayList();
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            this.estimate(gor, visitedStack);
        }
        this.predGorLpes.clear();
        this.estimated = true;
    }

    private void estimate(GeneralizedOrderRequest gor, List<GeneralizedOrderRequest> visitedGorStack) {
        if (!this.gorLpses.containsKey(gor)) {
            long lpe = Long.MAX_VALUE;
            visitedGorStack.add(gor);
            for (GeneralizedOrderRequest succGor : this.succGors.find(gor)) {
                if (!visitedGorStack.contains(succGor)) {
                    this.estimate(succGor, visitedGorStack);
                    long lpeFromSucc = this.predGorLpes.get(succGor);
                    if (lpeFromSucc >= lpe) continue;
                    lpe = lpeFromSucc;
                    continue;
                }
                if (this.superplan.getCustomerRequest(succGor.getId()) != null) continue;
                log.warn("Ignoring GORs in cycles: " + succGor.getId());
            }
            visitedGorStack.remove(visitedGorStack.size() - 1);
            if (lpe == Long.MAX_VALUE) {
                lpe = gor.getDueDate();
            }
            Lpse lpse = new Lpse();
            lpse.end = lpe;
            lpse.start = this.estimateGarLpes(gor, lpe);
            this.gorLpses.put(gor, lpse);
        }
    }

    private long estimateGarLpes(GeneralizedOrderRequest gor, long gorLpe) {
        long t = gorLpe;
        Lpse lpse = null;
        List<GeneralizedActionRequest> gars = gor.getGars();
        for (int i = gars.size() - 1; i >= 0; --i) {
            GeneralizedActionRequest predGar;
            Action predA;
            double tb;
            GeneralizedActionRequest gar = gars.get(i);
            Action a = gar.getAction();
            lpse = new Lpse();
            lpse.end = t;
            double qty = gar.getRequestedQty() - gar.getOutOfPlanQty();
            lpse.start = t = this.lpsComputer.getLps(a, qty, t);
            this.garLpses.put(gar, lpse);
            if (i > 0 && (tb = (predA = (predGar = gars.get(i - 1)).getAction()).getTransferBatch()) >= 0.0 && qty > tb) {
                long overlapPred = predA.timeToMake(qty - tb);
                long overlap = a.timeToMake(qty - tb);
                t = LongMath.checkedAdd(t, Math.min(overlap, overlapPred));
            }
            t = LongMath.checkedSubtract(t, a.getMinTimeToPrepare());
        }
        this.predGorLpes.put(gor, t);
        return lpse != null ? lpse.start : gorLpe;
    }

    @Override
    public long getLpe(GeneralizedActionRequest gar) {
        Lpse v = this.garLpses.get(gar);
        return v == null ? -9223372036854775708L : v.end;
    }

    @Override
    public long getLpe(GeneralizedOrderRequest gor) {
        Lpse v = this.gorLpses.get(gor);
        return v == null ? -9223372036854775708L : v.end;
    }

    @Override
    public long getLps(GeneralizedActionRequest gar) {
        Lpse v = this.garLpses.get(gar);
        return v == null ? -9223372036854775708L : v.start;
    }

    @Override
    public long getLps(GeneralizedOrderRequest gor) {
        Lpse v = this.gorLpses.get(gor);
        return v == null ? -9223372036854775708L : v.start;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum GorSuccesorsFrom {
        FEEDS_PROPERTY{

            @Override
            @Nonnull
            SuccGorFinder getSuccGorFinder(final Superplan superplan) {
                final PropertyDefinition feedsPd = superplan.getShopConf().getPropertyDefinition(GeneralizedOrderRequest.class, "feeds");
                return new SuccGorFinder(){

                    @Override
                    @Nonnull
                    public Iterable<GeneralizedOrderRequest> find(GeneralizedOrderRequest gor) {
                        ArrayList<GeneralizedOrderRequest> gors;
                        if (feedsPd != null) {
                            gors = Lists.newArrayList();
                            String feeds = Strings.nullToEmpty((String)gor.getProperty(feedsPd));
                            for (String fedGorId : Splitter.on(',').omitEmptyStrings().trimResults().split(feeds)) {
                                GeneralizedOrderRequest fedGor = superplan.getGor(fedGorId);
                                if (fedGor == null) continue;
                                gors.add(fedGor);
                            }
                        } else {
                            gors = Collections.emptyList();
                        }
                        return gors;
                    }
                };
            }
        }
        ,
        SD_GRAPH{

            @Override
            @Nonnull
            SuccGorFinder getSuccGorFinder(Superplan superplan) {
                final StoreDependencyGraph sdgraph = superplan.getSDGraph();
                return new SuccGorFinder(){

                    @Override
                    @Nonnull
                    public Iterable<GeneralizedOrderRequest> find(GeneralizedOrderRequest gor) {
                        return Collections2.transform(sdgraph.getNode(gor).getDirectSuccessors(SdgGorNode.class), new Function<SdgGorNode, GeneralizedOrderRequest>(){

                            @Override
                            @Nullable
                            public GeneralizedOrderRequest apply(@Nullable SdgGorNode input) {
                                return input.getGor();
                            }
                        });
                    }
                };
            }
        };


        @Nonnull
        abstract SuccGorFinder getSuccGorFinder(Superplan var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LpsEstimatesFrom {
        NON_STOP_ONLINE{

            @Override
            @Nonnull
            LpsComputer getLpsComputer(Superplan superplan) {
                return (a, qty, lpe) -> LongMath.checkedSubtract(lpe, a.timeToMake(qty));
            }
        }
        ,
        PLAN_OFFLINES{

            @Override
            @Nonnull
            LpsComputer getLpsComputer(Superplan superplan) {
                final Plan plan = superplan.getPlan();
                final ShopConfiguration conf = superplan.getShopConf();
                return new LpsComputer(){

                    @Override
                    public long getLps(Action a, double qty, long lpe) {
                        long maxLps = Long.MIN_VALUE;
                        long ttm = a.timeToMake(qty);
                        for (Workplace wp : conf.getWorkplaces(a.getCapabilityReq())) {
                            long lps = this.getLpsOnWorkplace(wp, ttm, lpe);
                            if (lps <= maxLps) continue;
                            maxLps = lps;
                        }
                        return maxLps;
                    }

                    private long getLpsOnWorkplace(Workplace wp, long ttm, long lpe) {
                        WorkplaceSchedule wps = plan.getWorkplaceSchedule(wp);
                        Iterator<WorkplaceActivity> iter = wps.backwardIteratorWithBubbles(lpe, true);
                        long t = ttm;
                        long lps = lpe;
                        while (iter.hasNext() && t > 0L) {
                            WorkplaceActivity wpa = iter.next();
                            if (wpa instanceof OfflineActivity) continue;
                            long end = Math.min(wpa.getEnd(), lpe);
                            long usable = end - wpa.getStart();
                            if (usable < 0L) {
                                usable = t;
                            }
                            long useT = Math.min(t, usable);
                            t -= useT;
                            lps = end - useT;
                        }
                        return lps;
                    }
                };
            }
        };


        @Nonnull
        abstract LpsComputer getLpsComputer(Superplan var1);
    }

    private static interface SuccGorFinder {
        @Nonnull
        public Iterable<GeneralizedOrderRequest> find(GeneralizedOrderRequest var1);
    }

    @VisibleForTesting
    protected static interface LpsComputer {
        public long getLps(Action var1, double var2, long var4);
    }

    private static class Lpse {
        private long start;
        private long end;

        private Lpse() {
        }
    }
}

